/*
 * Decompiled with CFR 0.152.
 */
package iRail;

import iRail.API;
import iRail.Connection;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class IRailMIDlet
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    private Connection[] connections = null;
    private Hashtable __previousDisplayables = new Hashtable();
    private Form PlanForm;
    private TextField fromTextfield;
    private ChoiceGroup choiceGroup;
    private DateField dateField;
    private TextField toTextfield;
    private StringItem stringItem;
    private List fromList;
    private List toList;
    private List optionsList;
    private Form tripDetailsForm;
    private StringItem tripDetailStringItem;
    private ImageItem tripDetailImageItem;
    private Command fromOK;
    private Command cancelCommand;
    private Command searchCommand;
    private Command exitCommand;
    private Command fromListOKCommand;
    private Command cancelFromListCommand;
    private Command cancelToListCommand;
    private Command optionsListBackCommand;
    private Command toListOKCommand;
    private Command okCommand;
    private Command tripDetailsbackCommand;
    private Command exitCommand1;
    private Image ICIRImage;
    private Image SImage;

    private void switchToPreviousDisplayable() {
        Displayable __nextDisplayable;
        Displayable __currentDisplayable = this.getDisplay().getCurrent();
        if (__currentDisplayable != null && (__nextDisplayable = (Displayable)this.__previousDisplayables.get(__currentDisplayable)) != null) {
            this.switchDisplayable(null, __nextDisplayable);
        }
    }

    private void initialize() {
    }

    public void startMIDlet() {
        this.switchDisplayable(null, (Displayable)this.getPlanForm());
    }

    public void resumeMIDlet() {
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        Displayable __currentDisplayable = display.getCurrent();
        if (__currentDisplayable != null && nextDisplayable != null) {
            this.__previousDisplayables.put(nextDisplayable, __currentDisplayable);
        }
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    public Form getPlanForm() {
        if (this.PlanForm == null) {
            this.PlanForm = new Form("Plan Trip", new Item[]{this.getFromTextfield(), this.getToTextfield(), this.getDateField(), this.getChoiceGroup(), this.getStringItem()});
            this.PlanForm.addCommand(this.getSearchCommand());
            this.PlanForm.addCommand(this.getExitCommand1());
            this.PlanForm.setCommandListener((CommandListener)this);
        }
        return this.PlanForm;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.PlanForm) {
            if (command == this.exitCommand1) {
                this.exitMIDlet();
            } else if (command == this.searchCommand) {
                this.switchDisplayable(null, (Displayable)this.getFromList());
            }
        } else if (displayable == this.fromList) {
            if (command == List.SELECT_COMMAND) {
                this.fromListAction();
            } else if (command == this.cancelFromListCommand) {
                this.switchToPreviousDisplayable();
            } else if (command == this.fromListOKCommand) {
                this.switchDisplayable(null, (Displayable)this.getToList());
            }
        } else if (displayable == this.optionsList) {
            if (command == List.SELECT_COMMAND) {
                this.optionsListAction();
            } else if (command == this.okCommand) {
                Connection connection = this.connections[this.optionsList.getSelectedIndex()];
                this.switchDisplayable(null, (Displayable)this.getTripDetailsForm());
                this.getTripDetailImageItem().setImage(this.getTrainTypeImage(connection.getTrainTypes()));
                this.getTripDetailStringItem().setText(connection.getViaText().replace('|', '\n'));
            } else if (command == this.optionsListBackCommand) {
                this.switchDisplayable(null, (Displayable)this.getPlanForm());
                this.optionsList = null;
            }
        } else if (displayable == this.toList) {
            if (command == List.SELECT_COMMAND) {
                this.toListAction();
            } else if (command == this.cancelToListCommand) {
                this.switchToPreviousDisplayable();
            } else if (command == this.toListOKCommand) {
                this.switchDisplayable(null, (Displayable)this.getOptionsList());
            }
        } else if (displayable == this.tripDetailsForm && command == this.tripDetailsbackCommand) {
            this.switchDisplayable(null, (Displayable)this.getOptionsList());
        }
    }

    public TextField getFromTextfield() {
        if (this.fromTextfield == null) {
            this.fromTextfield = new TextField("From", null, 32, 0);
        }
        return this.fromTextfield;
    }

    public DateField getDateField() {
        if (this.dateField == null) {
            this.dateField = new DateField("When", 3);
            this.dateField.setDate(new Date(System.currentTimeMillis()));
        }
        return this.dateField;
    }

    public ChoiceGroup getChoiceGroup() {
        if (this.choiceGroup == null) {
            this.choiceGroup = new ChoiceGroup("Time type", 1);
            this.choiceGroup.append("Departure", null);
            this.choiceGroup.append("Arrival", null);
            this.choiceGroup.setSelectedFlags(new boolean[]{false, false});
        }
        return this.choiceGroup;
    }

    public Command getFromOK() {
        if (this.fromOK == null) {
            this.fromOK = new Command("Ok", 4, 0);
        }
        return this.fromOK;
    }

    public Command getCancelCommand() {
        if (this.cancelCommand == null) {
            this.cancelCommand = new Command("Cancel", 3, 0);
        }
        return this.cancelCommand;
    }

    public Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 7, 0);
        }
        return this.exitCommand;
    }

    public Command getSearchCommand() {
        if (this.searchCommand == null) {
            this.searchCommand = new Command("Search", 4, 0);
        }
        return this.searchCommand;
    }

    public List getFromList() {
        if (this.fromList == null) {
            String[] stations = API.getStations(this.getFromTextfield().getString());
            this.fromList = new List("From", 3);
            this.fromList.addCommand(this.getCancelFromListCommand());
            this.fromList.addCommand(this.getFromListOKCommand());
            this.fromList.setCommandListener((CommandListener)this);
            for (int i = 0; i < stations.length; ++i) {
                if (stations[i] == null) continue;
                this.fromList.append(stations[i], null);
            }
        }
        return this.fromList;
    }

    public void fromListAction() {
        String __selectedString = this.getFromList().getString(this.getFromList().getSelectedIndex());
    }

    public Command getCancelFromListCommand() {
        if (this.cancelFromListCommand == null) {
            this.cancelFromListCommand = new Command("Cancel", 3, 0);
        }
        return this.cancelFromListCommand;
    }

    public Command getFromListOKCommand() {
        if (this.fromListOKCommand == null) {
            this.fromListOKCommand = new Command("Ok", 4, 0);
        }
        return this.fromListOKCommand;
    }

    public List getToList() {
        if (this.toList == null) {
            String[] stations = API.getStations(this.getToTextfield().getString());
            this.toList = new List("To", 3);
            this.toList.addCommand(this.getCancelToListCommand());
            this.toList.addCommand(this.getToListOKCommand());
            this.toList.setCommandListener((CommandListener)this);
            for (int i = 0; i < stations.length; ++i) {
                if (stations[i] == null) continue;
                this.toList.append(stations[i], null);
            }
        }
        return this.toList;
    }

    public void toListAction() {
        String __selectedString = this.getToList().getString(this.getToList().getSelectedIndex());
    }

    public Command getCancelToListCommand() {
        if (this.cancelToListCommand == null) {
            this.cancelToListCommand = new Command("Cancel", 3, 0);
        }
        return this.cancelToListCommand;
    }

    public TextField getToTextfield() {
        if (this.toTextfield == null) {
            this.toTextfield = new TextField("To", null, 32, 0);
        }
        return this.toTextfield;
    }

    public void optionsListAction() {
        String __selectedString = this.getOptionsList().getString(this.getOptionsList().getSelectedIndex());
    }

    public Command getToListOKCommand() {
        if (this.toListOKCommand == null) {
            this.toListOKCommand = new Command("Ok", 4, 0);
        }
        return this.toListOKCommand;
    }

    public Command getOptionsListBackCommand() {
        if (this.optionsListBackCommand == null) {
            this.optionsListBackCommand = new Command("Back", 2, 0);
        }
        return this.optionsListBackCommand;
    }

    public Command getOkCommand() {
        if (this.okCommand == null) {
            this.okCommand = new Command("Ok", 4, 0);
        }
        return this.okCommand;
    }

    public Image getICIRImage() {
        if (this.ICIRImage == null) {
            try {
                this.ICIRImage = Image.createImage((String)"/icir.PNG");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.ICIRImage;
    }

    public Image getSImage() {
        if (this.SImage == null) {
            try {
                this.SImage = Image.createImage((String)"/S-logo_yellow130C_B-blue (Custom) (2).PNG");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.SImage;
    }

    public List getOptionsList() {
        if (this.optionsList == null) {
            String from = this.fromList.getString(this.fromList.getSelectedIndex());
            String to = this.toList.getString(this.toList.getSelectedIndex());
            Calendar c = Calendar.getInstance();
            c.setTime(this.getDateField().getDate());
            int year = c.get(1);
            int month = c.get(2) + 1;
            int day = c.get(5);
            int hour = c.get(11);
            int minute = c.get(12);
            String yearShort = (year + "").substring(2, 4);
            String date = (day < 10 ? "0" : "") + day + (month < 10 ? "0" : "") + month + yearShort;
            String time = (hour < 10 ? "0" : "") + hour + "" + (minute < 10 ? "0" : "") + minute;
            this.connections = API.getConnections(from, to, time, date, this.getChoiceGroup().getString(this.getChoiceGroup().getSelectedIndex()).toLowerCase());
            this.optionsList = new List("Options", 3);
            this.optionsList.addCommand(this.getOptionsListBackCommand());
            this.optionsList.addCommand(this.getOkCommand());
            this.optionsList.setCommandListener((CommandListener)this);
            this.optionsList.setSelectedFlags(new boolean[0]);
            for (int i = 0; i < this.connections.length; ++i) {
                Connection connection = this.connections[i];
                if (connection != null) {
                    Image image = this.getTrainTypeImage(connection.getTrainTypes());
                    this.optionsList.append(connection.getDepartureTime() + " - " + connection.getArrivalTime(), image);
                }
                this.toList = null;
                this.fromList = null;
            }
        }
        return this.optionsList;
    }

    public Form getTripDetailsForm() {
        if (this.tripDetailsForm == null) {
            this.tripDetailsForm = new Form("Trip Details", new Item[]{this.getTripDetailImageItem(), this.getTripDetailStringItem()});
            this.tripDetailsForm.addCommand(this.getTripDetailsbackCommand());
            this.tripDetailsForm.setCommandListener((CommandListener)this);
        }
        return this.tripDetailsForm;
    }

    public ImageItem getTripDetailImageItem() {
        if (this.tripDetailImageItem == null) {
            this.tripDetailImageItem = new ImageItem("", null, 0, "<Missing Image>");
        }
        return this.tripDetailImageItem;
    }

    public StringItem getTripDetailStringItem() {
        if (this.tripDetailStringItem == null) {
            this.tripDetailStringItem = new StringItem("Details", null);
        }
        return this.tripDetailStringItem;
    }

    public Command getTripDetailsbackCommand() {
        if (this.tripDetailsbackCommand == null) {
            this.tripDetailsbackCommand = new Command("Back", 2, 0);
        }
        return this.tripDetailsbackCommand;
    }

    public Command getExitCommand1() {
        if (this.exitCommand1 == null) {
            this.exitCommand1 = new Command("Exit", 7, 0);
        }
        return this.exitCommand1;
    }

    public StringItem getStringItem() {
        if (this.stringItem == null) {
            this.stringItem = new StringItem("  ", "   ");
        }
        return this.stringItem;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            this.initialize();
            this.startMIDlet();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    private Image getTrainTypeImage(String trainTypes) {
        if (trainTypes.indexOf("S") >= 0) {
            return this.getSImage();
        }
        if (trainTypes.indexOf("L") >= 0) {
            return this.getSImage();
        }
        return this.getICIRImage();
    }
}

