/*
 * Decompiled with CFR 0.152.
 */
package iRail;

import iRail.Connection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import util.StringUtil;

public class API {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doCall(String path) throws IOException {
        String out = "";
        HttpConnection httpConn = null;
        String url = "http://irail-csv.maartje.dev" + path;
        InputStream is = null;
        OutputStream os = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)url);
            httpConn.setRequestMethod("GET");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                StringBuffer sb = new StringBuffer();
                os = httpConn.openOutputStream();
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    sb.append((char)chr);
                }
                out = sb.toString();
            } else {
                System.out.println("Error in opening HTTP Connection. Error#" + respCode);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return out;
    }

    public static String[] getStations(String search) {
        String[] out = null;
        try {
            String response = API.doCall("/stations?search=" + search);
            out = StringUtil.Split(response, "\n", 1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return out;
    }

    public static Connection[] getConnections(String from, String to, String time, String date, String timesel) {
        Vector<Connection> out = new Vector<Connection>();
        try {
            String response = API.doCall("/connections?from=" + from + "&to=" + to + "&date=" + date + "&time=" + time + "&timesel=" + timesel);
            String[] connections = StringUtil.Split(response, "\n", 1);
            for (int i = 0; i < connections.length; ++i) {
                String[] parts;
                String line = connections[i];
                if (line == null || (parts = StringUtil.Split(line, ",", 0)).length < 4) continue;
                out.addElement(new Connection(parts[0], parts[1], parts[2], parts[3]));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Connection[] connectionArray = new Connection[out.size()];
        for (int i = 0; i < connectionArray.length; ++i) {
            connectionArray[i] = (Connection)out.elementAt(i);
        }
        return connectionArray;
    }
}

